<?php
/**
 * Post metaboxes configuration
 *
 * @package  newpress.
 */

add_filter( 'rwmb_meta_boxes', 'newpresszc_register_meta_boxes' );
function newpresszc_register_meta_boxes( $meta_boxes ) {
    $prefix = 'newpresszc_';
    
	$meta_boxes[] = array(
        'id'         => 'Quote',
        'title'      => esc_html__( 'Post Quote', 'newpress' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Quote', 'newpress' ),
                'desc'  => esc_html__( 'Quote Text Add Here', 'newpress' ),
                'id'    => $prefix . 'post_quote',
                 'type'    => 'textarea',
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'Link',
        'title'      => esc_html__( 'Post Link', 'newpress' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Link', 'newpress' ),
                'desc'  => esc_html__( 'Link Add Here', 'newpress' ),
                'id'    => $prefix . 'post_link',
                 'type'    => 'text',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'blog-sections',
        'title'      => esc_html__( 'Post Gallery', 'newpress' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(
            array(
                'name'  => esc_html__( 'Gallery', 'newpress' ),
                'desc'  => '',
                'id'    => $prefix . 'post_gallery',
                'type'             => 'image_upload',

				// Delete file from Media Library when remove it from post meta?
				// Note: it might affect other posts if you use same file for multiple posts
				'force_delete'     => false,

				// Maximum file uploads.
				'max_file_uploads' => 10,

				// Do not show how many files uploaded/remaining.
				'max_status'       => 'false',

				// Image size that displays in the edit page.
				'image_size'       => 'thumbnail',
            ),
			
        )
    );
	$meta_boxes[] = array(
        'id'         => 'video-sections',
        'title'      => esc_html__( 'Post Video', 'newpress' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Video', 'newpress' ),
                'desc'  => esc_html__( 'Youtube & Viemo Url Add Here', 'newpress' ),
                'id'    => $prefix . 'post_video',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'audio-sections',
        'title'      => esc_html__( 'Post Audio', 'newpress' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Audio', 'newpress' ),
                'desc'  => esc_html__( 'Soundcloud Embed Ifram Add Here', 'newpress' ),
                'id'    => $prefix . 'post_audio',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	


      $meta_boxes[] = array(
        'id'         => 'Banner',
        'title'      => esc_html__( 'Banner Img', 'newpress' ),
        'post_types' => 'portfolio',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Banner Img', 'newpress' ),
                'desc'  => esc_html__( 'Banner Img Text Here', 'newpress' ),
                'id'    => $prefix . 'post_banner',
                 'type'    => 'image_advanced',
            ),
        )
    );
	
	$meta_boxes[] = array(
        'id'         => 'team-postions-sections',
        'title'      => esc_html__( 'Team Post', 'newpress' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Post', 'newpress' ),
                'desc'  => esc_html__( 'Text Add Here', 'newpress' ),
                'id'    => $prefix . 'post_team_postions',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-sections',
        'title'      => esc_html__( 'Team Social Icons', 'newpress' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'newpress' ),
                'desc'  => esc_html__( 'Text Add Here', 'newpress' ),
                'id'    => $prefix . 'post_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );



    // Add more meta boxes if you want
    // $meta_boxes[] = ...

    return $meta_boxes;
}