<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_testimonial extends Widget_Base {

	public function get_name() {
		return 'Elementor-testimonial';
	}

	public function get_title() {
		return esc_html__( 'Zc >  Testimonial' ,'newpress' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Testimonials','newpress'),]
		);
		
        
      $this->add_control(

            'background_img1',

            [

                'label' => esc_html__( 'Background Image 1' ,'newpress'),

                'type' => Controls_Manager::MEDIA,

            ]

            );
        
        $this->add_control(

            'background_img2',

            [

                'label' => esc_html__( 'Background Image 2' ,'newpress'),

                'type' => Controls_Manager::MEDIA,

            ]

            );
        
        
        
        
     

        $this->add_control(

            'text_heading',

            [

                'label' => esc_html__( 'Text Heading' ,'newpress'),

                'type' => Controls_Manager::TEXT,

            ]

            );
        
      
         $this->add_control(

				'symbol_img',

				[

					'label' => esc_html__( 'Symbol Image' ,'newpress'),

					'type' => Controls_Manager::MEDIA,

				]

				);
        
         				
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','newpress'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
				 [

						'name' => 'quotation_img',

						'label' => esc_html__( 'Quotation Image','newpress'),

						'type' => Controls_Manager::MEDIA,

					],
                    
                	[

						'name' => 'arrow_img',

						'label' => esc_html__( 'Arrow Image','newpress'),

						'type' => Controls_Manager::MEDIA,

					],    
                    
				   
						[

						'name' => 'features_img',

						'label' => esc_html__( 'features Image','newpress'),

						'type' => Controls_Manager::MEDIA,

					],
					
					[

					    'name' => 'features_img_switcher',

						'label' => esc_html__( 'features Image Switcher','newpress'  ),

						'type' => Controls_Manager::SWITCHER,

						'default' => 'yes',

						'label_on' => esc_html__( 'Show','newpress' ),

						'label_off' => esc_html__( 'Hide','newpress'  ),

						'return_value' => 'yes',

					],
					
					
					
                    [
						'name' => 'name',
						'label' => esc_html__( 'name' ,'newpress' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    
                    [
						'name' => 'position',
						'label' => esc_html__( 'Position' ,'newpress' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'newpress' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
					
                    
                    
                    
					
					
				],
			]
		);
         
		$this->end_controls_section();
		
			$this->start_controls_section(
			 'section_style_icon2',
			 [
				'label' => esc_html__( 'Text Color', 'newpress' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]	 
		);	
			
			 $this->add_control(
			'price_color',
			[
				'name' => 'price_color',

				'label' => esc_html__( 'Title Color', 'newpress' ),

				'type' => Controls_Manager::COLOR,

				 'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'default' => '#0e1b30',
				'selectors' => [
					'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_control(
			'price_color_sub',
			[
				'name' => 'price_color',

				'label' => esc_html__( 'Sub Title Color', 'newpress' ),

				'type' => Controls_Manager::COLOR,

				 'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'default' => '#ff3d4f',
				'selectors' => [
					'{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
				],
			]
		); 
	
		$this->add_control(
			'timeline_color_sub',
			[
				'name' => 'price_color',

				'label' => esc_html__( 'Icon Color', 'newpress' ),

				'type' => Controls_Manager::COLOR,

				 'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'default' => '#0e1b30',
				'selectors' => [
					'{{WRAPPER}} .testimonial-active i' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_control(
			'timeline_text_color',
			[
				'name' => 'price_color',

				'label' => esc_html__( 'Text Color', 'newpress' ),

				'type' => Controls_Manager::COLOR,

				 'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'default' => '#777777',
				'selectors' => [
					'{{WRAPPER}} .single-testimonial p' => 'color: {{VALUE}};',
				],
			]
		); 
		
	}

	protected function render( $instance = [] ) {

		newpress_el()->get_section('testimonial', [
			'service_section_var' => $this->get_settings('service_section'), 
			'column_section_data' => $this->get_settings('column_section'),
			'hading_section_data' => $this->get_settings('heading-text'),
			'background_img1' => $this->get_settings('background_img1'),
			'background_img2' => $this->get_settings('background_img2'),
             'text_heading' => $this->get_settings('text_heading'),        
        	'symbol_img' => $this->get_settings('symbol_img'),
            
            
            
			
		   
            'img' => $this->get_settings('img'),          
           	'left_img_text_data' => $this->get_settings('left-img-text'),
            'menu-id01' => $this->get_settings('menu-id'),
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_testimonial() );