<?php

namespace Elementor;



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



class Elementor_team extends Widget_Base {



	public function get_name() {

		return 'Elementor-team';

	}



	public function get_title() {

		return esc_html__( 'Zc >  Team' ,'newpress' );

	}



	public function get_icon() {

		

		return 'eicon-icon-box';

	}



	protected function _register_controls() {

		$traits = new \newpress_Elementor_Traits($this);

		
        
        

		$this->start_controls_section(

			'services_section',

			['label' => esc_html__( 'Our Team','newpress'),]

		);
        
        
        	$this->add_control(

			'text_heading',

			[

				'label' => esc_html__( 'Top Heading' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
        
        	$this->add_control(

			'symbol_img',

			[

				'label' => esc_html__( 'Symbol Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
        
        
        
        
			
         /////social link///
		$social_links_list = [
			[
				'name' => 'select_social_networks',
				'label' => esc_html__( 'Social Networks','newpress' ),
				'type' => Controls_Manager::HEADING,
			]
		];

		for ($i = 1; $i <= 5; $i++) {
			$social_links_list[] = [
				'name' => 'social_network_icon__' . $i,
				'label' => esc_html__( 'Icon','newpress' ),
				'type' => Controls_Manager::TEXT,
			];

			$social_links_list[] = [
				'name' => 'social_network_link__' . $i,
				'label' => esc_html__( 'URL','newpress' ),
				'type' => Controls_Manager::URL,
				'default' => [
					'url' => '',
					'is_external' => true,
				],
				'show_external' => false,
				'separator' => 'after',
			];
		}
        

            $this->add_control(
                    'posts_per_page',
                    [
                        'label'   => esc_html__( 'Number of items to show', 'newpress' ),
                        'type'    => Controls_Manager::NUMBER,
                        'default' => 4,
                    ]
                );
         

		$this->end_controls_section();

	}



	protected function render( $instance = [] ) {
        
		newpress_el()->get_section('team', [

			'service_section_var1' => $this->get_settings('service_section1'),
			'text_heading' => $this->get_settings('text_heading'),
			'symbol_img' => $this->get_settings('symbol_img'),
             'posts_per_page' => $this->get_settings('posts_per_page'),
			
        
        ]);

	}



	protected function content_template() {}



	public function render_plain_content() {}



}



Plugin::instance()->widgets_manager->register_widget_type( new Elementor_team() );