<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_service_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-service-widget';
	}

	public function get_title() {
		return __( 'Zc >  Service Box' ,'newpress' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Service Section','newpress'),]
		);
        
        
           $this->add_control(
             
			'background_img',

			[

				'label' => esc_html__( 'Background Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
        
        
        
        
         $this->add_control(
             
			'text_heading',

			[

				'label' => esc_html__( 'Text Heading' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
        
         $this->add_control(
             
			'symbol_img',

			[

				'label' => esc_html__( 'Symbol Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
         $this->add_control(
             
			'symbol',

			[

				'label' => esc_html__( 'Symbol ' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
     
       
       
        
        
	
		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'newpress' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);
        
        
        
        
        
        
        
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		newpress_el()->get_section('service', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
			'background_img' => $this->get_settings('background_img'),
			'text_heading' => $this->get_settings('text_heading'),
			'symbol_img' => $this->get_settings('symbol_img'),
			'symbol' => $this->get_settings('symbol'),
			'posts_per_page' => $this->get_settings('posts_per_page'),
			


			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_service_box() );