<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_Recent_Post extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-Recent-Post';
	}

	public function get_title() {
		return esc_html__( 'Zc > Recent Post Feed', 'newpress' );
	}

	public function get_icon() {
		return 'eicon-posts-masonry';
	}

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);

		$this->start_controls_section(
			'featured_post_controller',
            
			['label' => esc_html__( 'Recent Post Feed', 'newpress' ),]
		);
		
			
        
        $this->add_control(

			'text_heading',

			[

				'label' => esc_html__( 'Text Heading' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
      
          
        $this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'newpress' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);
        
       

		$this->add_control(
			'select_categories',
			[
				'label' => esc_html__( 'Filter by Categories', 'newpress' ),
				'type' => Controls_Manager::SELECT2,
				'options' => newpress_el()->get_terms_dropdown_array([
					'taxonomy' => 'category',
					'hide_empty' => false,
					]),
				'multiple' => true,
			]
		);
        

		$this->add_control(
			'select_posts',
			[
				'label' => esc_html__( 'Filter by Post.', 'newpress' ),
				'type' => Controls_Manager::SELECT2,
				'options' => newpress_el()->get_posts_dropdown_array([
					'post_type' => 'post',
					'posts_per_page' => -1,
					]),
				'multiple' => true,
			]
		);
        
         $this->add_control(

			'banner',

			[

				'label' => esc_html__( 'Banner' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
            $this->add_control(

			'text_heading1',

			[

				'label' => esc_html__( 'Heading 1' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
         $this->add_control(

			'img',

			[

				'label' => esc_html__( 'Side Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
            $this->add_control(

			'title',

			[

				'label' => esc_html__( 'Title' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
        
        
        
        
        
        
        
        
        
        
        
        
        $this->end_controls_section();
	}

	protected function render( $instance = [] ) {
        
		newpress_el()->get_section('recent-post', [
			
			'text_heading' => $this->get_settings('text_heading'),
			'text_heading1' => $this->get_settings('text_heading1'),
			
            
            'brk-img' => $this->get_settings('brk-img'),  
			'img' => $this->get_settings('img'),
			'menu-id01' => $this->get_settings('menu-id'),
			
           'posts_per_page' => $this->get_settings('posts_per_page'),  
			'category' => $this->get_settings('select_categories'),
			'include' => $this->get_settings('select_posts'),
			'banner' => $this->get_settings('banner'),
			'img' => $this->get_settings('img'),
			'title' => $this->get_settings('title'),
            
          
          
             'desc' => $this->get_settings('desc'),
			'paged' => ( get_query_var('paged') ) ? get_query_var('paged') : 1,
			
            
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_Recent_Post() );
