<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_price_icon_widget extends Widget_Base {

	public function get_name() {
		return 'Elementor-price-icon';
	}

	public function get_title() {
		return esc_html__( 'Zc > Price' ,'newpress');
	}

	public function get_icon() {
		
		return 'eicon-price-table';
	}

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);
		
		$this->start_controls_section(
			'price-icon-control',
			['label' => esc_html__( 'Price Section','newpress'),]
		);
        
        
     
            
        
		$this->add_control(
			'Repeator',
			[
				'label' => esc_html__( 'Services Icon','newpress'),
				'type' => Controls_Manager::REPEATER,
				'fields' =>array_merge([
                    
                    [
						'name' => 'icon',
						'label' => esc_html__( 'Icon Image' ,'newpress' ),
						'type' => Controls_Manager::TEXT,
						 
			       ],
                    
                                    
                    
                  [

						'name' => 'active_changer',

					   'label' => esc_html__( 'active', 'newpress'),

					   'type' => Controls_Manager::SELECT2,

					   'default' => 'd-active',

					   'options' => [

						'd-active' => esc_html__( 'D-Active', 'newpress'),

						'active' => esc_html__( 'Active', 'newpress'),

						

					    ],

					],
                    
                     [
						'name' => 'text',
						'label' => esc_html__( 'Text' ,'newpress' ),
						'type' => Controls_Manager::TEXT,
						 
					  ],	
				
				     	
				
                    [
						'name' => 'price',
						'label' => esc_html__( 'price','newpress'),
						'type' => Controls_Manager::TEXT,
					],
				   
				  
					[
						'name' => 'content',
						'label' => esc_html__( 'content' ,'newpress'),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
                    
					
					[

						'name' => 'price-button',

						'label' => esc_html__( 'Price Button Text' ,'newpress'),

						'type' => Controls_Manager::TEXT,

					],
					
					[

						'name' => 'price-button-link',

						'label' => esc_html__( 'url' ,'newpress'),

						'type' => Controls_Manager::URL,

						'default' => [

							'url' => '',

							'is_external' => true,

						],

						'show_external' => false,

						'separator' => 'after',

					],
					
				]),
			]
		);
         

		$this->end_controls_section();
		

	}

	protected function render( $instance = [] ) {

		newpress_el()->get_section('price', [
            
            
			'Repeators' => $this->get_settings('Repeator'),
			
			
            
	       
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_price_icon_widget() );