<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Elementor_portfolio extends Widget_Base
{
	public function get_name()
	{
		return 'Elementor-portfolio-widget';
	}

	public function get_title()
	{
		return __('Zc >  Portfolio', 'newpress');
	}

	public function get_icon()
	{
		return 'eicon-icon-box';
	}

	protected function _register_controls()
	{
		$traits = new \newpress_Elementor_Traits($this);
		$this->start_controls_section('section_tab', ['label' => esc_html__('Portfolio', 'newpress'),]);
        
       
        
        
        
       
        
       
        
        $this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'newpress' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);
        
        
		$this->add_control(
			'style',
			[
				'type' => Controls_Manager::SELECT, 'label' => esc_html__('Choose Style', 'newpress'), 'default' => 'style1',
				'label_block' => true, 'options' => [
					'style1' => esc_html__('Portfolio Normal', 'newpress'), 
					'style2' => esc_html__('Portfolio Filter', 'newpress'), 
                    'style3' => esc_html__('Portfolio Carousel', 'newpress'),
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render($instance = [])
	{
		$settings = $this->get_settings();        
                
        $posts_per_page = $settings['posts_per_page'];
		$style = $settings['style'];
		switch ($style) {
			case 'style1':
				require get_template_directory() . '/inc/sections/portfolio/style1.php';
				break;
                
            case 'style2':
				require get_template_directory() . '/inc/sections/portfolio/style2.php';
				break;              
          

			case 'style3':
				require get_template_directory() . '/inc/sections/portfolio/style3.php';
				break;
		}
	}
	protected function content_template() {}
	public function render_plain_content() {}
}

Plugin::instance()->widgets_manager->register_widget_type(new Elementor_portfolio());
