<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_header_slider extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-header-slider';
	}

	public function get_title() {
		return esc_html__( 'Zc > Header Slider', 'newpress' );
	}

	public function get_icon() {
		return 'eicon-posts-masonry';
	}

	
        
        
        protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);

		$this->start_controls_section(
			'header_slider_controller',
			['label' => esc_html__( 'Header Slider Feed', 'newpress' ),]
		);
            
            
            
		
        
        $this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'newpress' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);

        
        	$this->add_control(
			'select_categories',
			[
				'label' => esc_html__( 'Filter by Categories', 'newpress' ),
				'type' => Controls_Manager::SELECT2,
				'options' => newpress_el()->get_terms_dropdown_array([
					'taxonomy' => 'category',
					'hide_empty' => false,
					]),
				'multiple' => true,
			]
		);
        
        
        
        $this->add_control(
			'select_posts',
			[
				'label' => esc_html__( 'Filter by Post.', 'newpress' ),
				'type' => Controls_Manager::SELECT2,
				'options' => newpress_el()->get_posts_dropdown_array([
					'post_type' => 'post',
					'posts_per_page' => -1,
					]),
				'multiple' => true,
			]
		);
        
        


		$this->end_controls_section();


	}

	protected function render( $instance = [] ) {

		newpress_el()->get_section('header-slider', [
           
            
            
            'posts_per_page' => $this->get_settings('posts_per_page'),           
            'category' => $this->get_settings('select_categories'),
            'include' => $this->get_settings('select_posts'),
             'paged' => ( get_query_var('paged') ) ? get_query_var('paged') : 1,
            
            
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_header_slider() );
