<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_features_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-features-box-widget';
	}

	public function get_title() {
		return __( 'Zc >  Features Box' ,'newpress' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Features','newpress'),]
		);
        

         $this->add_control(
			'line_image',

			[

				'label' => esc_html__( 'Line Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
         $this->add_control(
			'main_image',

			[

				'label' => esc_html__( 'Main Image' ,'newpress'),

				'type' => Controls_Manager::MEDIA,

			]

			);
        
        
         $this->add_control(
			'title',

			[

				'label' => esc_html__( 'Title' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        
        $this->add_control(
			'sub_title',

			[

				'label' => esc_html__( 'Sub Title' ,'newpress'),

				'type' => Controls_Manager::TEXT,

			]

			);
        $this->add_control(
			'des',

			[

				'label' => esc_html__( 'Description' ,'newpress'),

				'type' => Controls_Manager::TEXTAREA,

			]

			);
        
        
        $this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','newpress'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
				 [

						'name' => 'column_changer',

					   'label' => esc_html__( 'Column', 'newpress'),

					   'type' => Controls_Manager::SELECT2,

					   'default' => 'col-sm-4 col-lg-4',

					   'options' => [

						'col-sm-3 col-lg-3' => esc_html__( '3 column', 'newpress'),

						'col-sm-4 col-lg-4' => esc_html__( '4 column', 'newpress'),

						'col-sm-12 col-lg-6' => esc_html__( '6 column', 'newpress'),

						

									],

					],
				           		
					[
						'name' => 'icon',
						'label' => esc_html__( 'Icon','newpress'),
						'type' => Controls_Manager::TEXT,
					],
					
					
					[
					    'name' => 'icon_switcher',
						'label' => esc_html__( 'Icon Switcher','newpress'  ),
						'type' => Controls_Manager::SWITCHER,
						'default' => 'yes',
						'label_on' => esc_html__( 'Show','newpress' ),
						'label_off' => esc_html__( 'Hide','newpress'  ),
						'return_value' => 'yes',
					],					
					
					[
						'name' => 'text',
						'label' => esc_html__( 'Text' ,'newpress' ),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'content',
						'label' => esc_html__( 'Content','newpress'),
						'type' => Controls_Manager::TEXTAREA,
					],
					[

						'name' => 'link-text',

						'label' => esc_html__( 'Button Text','newpress'),

						'type' => Controls_Manager::TEXT,

					],
					[

						'name' => 'link-hrf-btn',

						'label' => esc_html__( 'Button Link','newpress'),

						'type' => Controls_Manager::URL,

					],
					
					
					
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		newpress_el()->get_section('features-box', [
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
			'title' => $this->get_settings('title'),
			'sub_title' => $this->get_settings('sub_title'),
			'line_image' => $this->get_settings('line_image'),
			'main_image' => $this->get_settings('main_image'),
			'des' => $this->get_settings('des'),

			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_features_box() );