<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_faq extends Widget_Base {

	public function get_name() {
		return 'Elementor_faq';
	}

	public function get_title() {
		return esc_html__( 'Zc > Faq','newpress');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \newpress_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'why_choose Section','newpress'),]
		);

			
				
			
			$this->add_control(

			'service_section',

			[

				'label' => esc_html__( 'Repeator Text','newpress'),

				'type' => Controls_Manager::REPEATER,

				'fields' => [
                    [

						'name' => 'text-id',

						'label' => esc_html__( 'Tab id ' ,'newpress' ),

						'type' => Controls_Manager::TEXT,

					],
						 
					[

						'name' => 'text',

						'label' => esc_html__( 'Text' ,'newpress' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','newpress'),

						'type' => Controls_Manager::TEXTAREA,

					],
					

				],

			]

		);
        
        
        	$this->add_control(

			'service_section1',

			[

				'label' => esc_html__( 'Repeator Text','newpress'),

				'type' => Controls_Manager::REPEATER,

				'fields' => [
                    [

						'name' => 'text-id',

						'label' => esc_html__( 'Tab id ' ,'newpress' ),

						'type' => Controls_Manager::TEXT,

					],
						 
					[

						'name' => 'text',

						'label' => esc_html__( 'Text' ,'newpress' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','newpress'),

						'type' => Controls_Manager::TEXTAREA,

					],
					

				],

			]

		);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		newpress_el()->get_section('faq', [
			'service_section_var' => $this->get_settings('service_section'),
			'service_section_var1' => $this->get_settings('service_section1'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_faq() );
