<?php

namespace Elementor;



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



class Elementor_Widget_contacts extends Widget_Base {



	public function get_name() {

		return 'Elementor_contacts-widget';

	}

	public function get_title() {

		return esc_html__( 'Zc > Contact Sections','newpress');

	}

	public function get_icon() {		

		 return 'eicon-image-box';

	 }



	protected function _register_controls() {

		$traits = new \newpress_Elementor_Traits($this);


		$this->start_controls_section(

			'the_header_controls',

			['label' => esc_html__( 'Contact Section','newpress'),]

		);	
        
        
        
      
        
        

        $this->add_control(

			'shortcode',

			[

				'label' => esc_html__( 'Enter your shortcode' ,'newpress'),

				'type' => Controls_Manager::TEXTAREA,

			]

			);
        
        
        	$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','newpress'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
				
				           		
					[
						'name' => 'icon',
						'label' => esc_html__( 'Icon','newpress'),
						'type' => Controls_Manager::MEDIA,
					],
                    
                    
                    
                [

						'name' => 'text',

						'label' => esc_html__( 'Heading' ,'newpress' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','newpress'),

						'type' => Controls_Manager::TEXTAREA,

					],    
					
					
					
					
					
					
				],
			]
		);


		$this->end_controls_section();

	}



	protected function render( $instance = [] ) {


		newpress_el()->get_section('contact-sections', [
            
            'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),

			
			
			
            
            
			'shortcode' => $this->get_settings('shortcode'),
            
			]);

	}



	protected function content_template() {}
	public function render_plain_content() {}


}


Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_contacts() );

