<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Elementor_About_box extends Widget_Base {
public function get_name() {
return 'Elementor-About-widget';
}
public function get_title() {
return __( 'Zc >  About' ,'newpress' );
}
public function get_icon() {
return 'eicon-slider-device';
}
protected function _register_controls() {
$traits = new \newpress_Elementor_Traits($this);
$this->start_controls_section(
'section_tab', [
'label' =>esc_html__( 'About', 'newpress' ),
]
);
$this->add_control(
'style', [
'type'         => Controls_Manager::SELECT,
'label'         => esc_html__( 'Choose Style', 'newpress' ),
'default'     => 'style1',
'label_block'     => true,
'options'     => [
'style1' =>esc_html__( 'About Style 1', 'newpress' ),
'style2' =>esc_html__( 'About Style 2', 'newpress' ),
'style3' =>esc_html__( 'About Style 3', 'newpress' ),
'style4' =>esc_html__( 'About Style 4', 'newpress' ),
                  
],
]
);
$this->add_control(
'icon', [
'label'             =>esc_html__( 'Icon', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);

$this->add_control(
			'header_background_color',
			[
				'label' => __( 'Background Color Overlay', 'newpress' ),
				'type' => Controls_Manager::COLOR,
				'condition'      => [
					'style' =>['style2','style3'],
					],
				'selectors' => [
					'{{WRAPPER}} .slider-bg2::before,.slider-bg3::before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .slider-bg2 .slider-content.second-slider-content::before,.slider-bg2 .slider-content.second-slider-content::after' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		

$this->add_control(
'about_backgrund_images', [
'label'             =>esc_html__( 'Background Image', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style4'],
],
]
);
    $this->add_control(
'main_img', [
'label'             =>esc_html__( 'Main Image', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style2','style3','style4'],
],
]
);
    
$this->add_control(
'icon_images', [
'label'             =>esc_html__( 'Icon Images', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style2','style3'],
],
]
);  
$this->add_control(
'user_image', [
'label'             =>esc_html__( 'User Image', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);      
$this->add_control(
'text_heading', [
'label'             =>esc_html__( 'Text Heading', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1','style2','style3'],
],
]
);    
$this->add_control(
'sub_heading', [
'label'             =>esc_html__( 'Sub Heading', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'label_block'     => true,
'placeholder'     =>esc_html__( 'newpress Text', 'newpress' ),
'default'         =>esc_html__( 'newpress', 'newpress' ),
'condition'      => [
'style' =>['style1','style2','style4'],
],
]
);      

$this->add_control(
'header_video', [
'label'             =>esc_html__( 'Choose File Video', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);
   
$this->add_control(
'name', [
'label'             =>esc_html__( 'User Name', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);    
$this->add_control(
'potions', [
'label'             =>esc_html__( 'Position', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);        
$this->add_control(
'signature', [
'label'             =>esc_html__( 'User Signature Image', 'newpress' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);      

 
    

$this->add_control(
'desc_title', [
'label'             =>esc_html__( 'Description', 'newpress' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'newpress Text', 'newpress' ),
'default'         =>esc_html__( 'newpress', 'newpress' ),
'condition'      => [
'style' => ['style1','style2','style3','style4']
],
]
);
   
$this->add_control(
'slider_button', [
'label'             =>esc_html__( 'Slider Button Text', 'newpress' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'newpress Text', 'newpress' ),
'default'         =>esc_html__( 'Read More', 'newpress' ),
'condition'      => [
'style' => ['style5']
],
]
);
$this->add_control(
'button_text', [
'label'             =>esc_html__( 'Button Text', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>[ 'style1','style2','style3'],
],
]
);
$this->add_control(
'button_link', [
'label'             =>esc_html__( 'Button URL', 'newpress' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1','style2','style3'],
],
]
);
$this->add_control(
'button_text1', [
'label'             =>esc_html__( 'Button Text 1', 'newpress' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);    
$this->add_control(
'button_link1', [
'label'             =>esc_html__( 'Button URL 1', 'newpress' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style5'],
],
]
);


$this->add_control(
'shortcode',
[
'label' => __( 'Enter your shortcode', 'newpress' ),
'type' => Controls_Manager::TEXTAREA,
'dynamic' => [
'active' => true,
],
'placeholder' => '[gallery id="123" size="medium"]',
'default' => '',
'condition'      => [
'style' => ['style3']
],
]
);
$this->add_responsive_control(
'title_align', [
'label'             =>esc_html__( 'Alignment', 'newpress' ),
'type'             => Controls_Manager::CHOOSE,
'options'         => [
'left'         => [
'title'     =>esc_html__( 'Left', 'newpress' ),
'icon'     => 'fa fa-align-left',
],
'center'     => [
'title'     =>esc_html__( 'Center', 'newpress' ),
'icon'     => 'fa fa-align-center',
],
'right'         => [
'title'     =>esc_html__( 'Right', 'newpress' ),
'icon'     => 'fa fa-align-right',
],
'justify'     => [
'title'     =>esc_html__( 'Justified', 'newpress' ),
'icon'     => 'fa fa-align-justify',
],
],
'default'         => '',
'selectors' => [
'{{WRAPPER}} .inner-item' => 'text-align: {{VALUE}};',
],
]
);
$this->end_controls_section();
}
protected function render( $instance = [] ) {
$settings = $this->get_settings();
$style = $settings[ 'style' ];
$about_backgrund_images = $settings[ 'about_backgrund_images' ];    
$main_img = $settings[ 'main_img' ];    
$icon_images = $settings[ 'icon_images' ];
$user_image = $settings[ 'user_image' ];
$text_heading = $settings[ 'text_heading' ];
$sub_heading = $settings[ 'sub_heading' ];
$name = $settings[ 'name' ];
$potions = $settings[ 'potions' ];
$signature = $settings[ 'signature' ];
$desc_title = $settings[ 'desc_title' ];
$slider_button = $settings[ 'slider_button' ];
$icon = $settings[ 'icon' ];
$button_text = $settings[ 'button_text' ];
$button_link = $settings[ 'button_link' ];
$button_text1 = $settings[ 'button_text1' ];
$button_link1 = $settings[ 'button_link1' ];
$shortcode = $settings[ 'shortcode' ];
$header_video = $settings[ 'header_video' ];

switch ( $style ) {
case 'style1':
require get_template_directory() . '/inc/sections/about/style1.php';
break;
case 'style2':
require get_template_directory() . '/inc/sections/about/style2.php';
break;
case 'style3':
require get_template_directory() . '/inc/sections/about/style3.php';
break;
case 'style4':
require get_template_directory() . '/inc/sections/about/style4.php';
break;        
}
}
protected function content_template() {}
public function render_plain_content() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_About_box() );