<?php
    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/newpress/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "newpress_data";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
      'opt_name' => 'newpress_data',
      'dev_mode' => false,
      'use_cdn' => true,
      'display_name' => $theme->get( 'Name' ),
      'display_version' => $theme->get( 'Version' ),
      'page_slug' => '_options',
      'page_title' => esc_html__('Theme Options', 'newpress'),
      'admin_bar' => true,
      'menu_type' => 'menu',
      'menu_title' => esc_html__('Theme Options', 'newpress'),
      'admin_bar_icon' => 'dashicons-admin-generic',
      'allow_sub_menu' => true,
      'page_parent_post_type' => 'your_post_type',
      'customizer' => true,
      'hints' => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_size'     => 'normal',
        'tip_style'     => array(
          'color' => 'dark',
        ),
        'tip_position' => array(
          'my' => 'top left',
          'at' => 'bottom right',
        ),
        'tip_effect' => array(
          'show' => array(
            'duration' => '500',
            'event'    => 'mouseover',
          ),
          'hide' => array(
            'duration' => '500',
            'event'    => 'mouseleave unfocus',
          ),
        ),
      ),
      'output' => true,
      'output_tag' => true,
      'settings_api' => true,
      'cdn_check_time' => '1440',
      'compiler' => true,
      'page_permissions' => 'manage_options',
      'save_defaults' => true,
      'show_import_export' => true,
      'transient_time' => '3400',
      'network_sites' => true,
      'disable_tracking' => true,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // General Settings
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Settings', 'newpress' ),
      'id'     => 'newpress__section-general',
      'icon'   => 'el el-cogs',
      'fields' => array(
        array(
          'id'        => 'newpress__opt-logo-standard',
          'type'      => 'media',
          'url'       => true,
          'title'     => esc_html__('Logo Image 1', 'newpress'),
          'compiler'  => 'true',
          'desc'      => esc_html__('Upload your image or remove image', 'newpress'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/logo.png'),
        ),

      )
    ) );
    



// Header email and phone number Top Bar
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Header Top Bar', 'newpress' ),
      'id'     => 'newpress__subsection-header-top-bar ',
      'fields' => array(
		array(
          'id'        => 'newpress__opt-Header-layout',
          'title'     => esc_html__('Change Header Layout', 'newpress'),
		   'type'     => 'image_select',
          'options'   => array(
				11 => array(

					'img' => get_template_directory_uri() . '/inc/admin/images/hader01.png',
					'alt' => 'Header Layout 1'
				),	
              
             
            	
		  ),

		  'default' => 11

        ),


        array(
          'id'        => 'newpress_opt-header-top-bar',
          'type'      => 'switch',
          'title'     => esc_html__('Show Header Top Bar?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to show Top Bar in the top of the Header.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
       
          
      
        array(
          'id'        => 'newpress_opt-header-top-bar-trending-tag',
          'type'      => 'switch',
          'title'     => esc_html__('Display Trending Tag?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the trending tag in the Header Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),


        array(
          'id'        => 'newpresst_opt-header-top-trending-tag',
          'type'      => 'textarea',
          'title'     => esc_html__('Trending Tag', 'newpress'),
          'subtitle'  => esc_html__('Trending Tag to display next to the envelope icon.', 'newpress'),
          'subtitle'  => esc_html__('Trending Tag to display next to the envelope icon.', 'newpress'),
          'default'   => esc_html__('Trending Tag', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-trending-tag', '=', '1'),
        ),


        array(
          'id'        => 'newpress_opt-header-top-bar-moving-desc',
          'type'      => 'switch',
          'title'     => esc_html__('Display Moving Description?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the moving descripion in the Header Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
        array(
          'id'        => 'newpress_opt-header-top-moving-desc',
          'type'      => 'textarea',
          'title'     => esc_html__('Moving Description', 'newpress'),
          'subtitle'  => esc_html__('Moving Description to display next to the envelope icon.', 'newpress'),
          'default'   => esc_html__('Moving Description', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-moving-desc', '=', '1'),
        ),    
          
         array(
          'id'        => 'newpress_opt-header-top-bar-temp',
          'type'      => 'switch',
          'title'     => esc_html__('Display City Temperature?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the city temperature in the Header Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
        array(
          'id'        => 'newpress_opt-header-top-temp',
          'type'      => 'text',
          'title'     => esc_html__('City Temperature', 'newpress'),
          'subtitle'  => esc_html__('To display the city temperature next to the envelope icon.', 'newpress'),
          'default'   => esc_html__(' city temperature', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-temp', '=', '1'),
        ),  
          
            array(
          'id'        => 'newpress_opt-header-top-bar-calender',
          'type'      => 'switch',
          'title'     => esc_html__('Display Calender?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the Calender in the Header Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
        array(
          'id'        => 'newpress_opt-header-top-calender',
          'type'      => 'textarea',
          'title'     => esc_html__('Display Calender', 'newpress'),
          'subtitle'  => esc_html__('To display the calender next to the envelope icon.', 'newpress'),
          'default'   => esc_html__(' banner', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-calender', '=', '1'),
        ),    
          
          array(
          'id'        => 'newpress_opt-header-top-bar-phone',
          'type'      => 'switch',
          'title'     => esc_html__('Display Phone Number?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the phone number in the Side Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
        array(
          'id'        => 'newpress_opt-header-top-phone',
          'type'      => 'text',
          'title'     => esc_html__('Display Phone Number', 'newpress'),
          'subtitle'  => esc_html__('To display the phone number next to the side menu.', 'newpress'),
          'default'   => esc_html__(' phone', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-phone', '=', '1'),
        ),      
          
         array(
          'id'        => 'newpress_opt-header-top-bar-email',
          'type'      => 'switch',
          'title'     => esc_html__('Display Email?', 'newpress'),
          'subtitle'  => esc_html__('Turn on to display the email in the side  Top Bar.', 'newpress'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'newpress'),
          'off'       => esc_html__('No', 'newpress'),
        ),
        array(
          'id'        => 'newpresst_opt-header-top-email',
          'type'      => 'text',
          'title'     => esc_html__('Display Email', 'newpress'),
          'subtitle'  => esc_html__('To display the email next to the envelope icon.', 'newpress'),
          'default'   => esc_html__(' info@example.com', 'newpress'),
          'required'  => array('newpress_opt-header-top-bar-email', '=', '1'),
        ),        
              
           
                
    
      )
    ) );



	// Header Right Menu

 Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Header Right Menu ', 'newpress' ),
      'id'     => 'newpress__subsection-right-menu1',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'newpress__opt-right-menu',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'newpress'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'newpress' ),
            'off'       => esc_html__( 'No', 'newpress' ),
          ),

          array(
            'id'      => 'newpress__right-menu',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Right Menu Text', 'newpress' ),
			'default'   => 1,
            'default' => ' <a href="contact.html" class="btn ss-btn">Get A Quote</a>',
            'required'  => array('newpress__opt-right-menu', '=', '1'),
          ),
      )
        
        
        
        
    ) );

	
     


	 ///////////////////////////////////////////////////////// Theme color///////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Colors', 'newpress' ),
      'id'     => 'newpress__section-color',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );

	Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Theme Colors', 'newpress' ),
      'id'     => 'newpress__subsection-general-theme-color',
	  'subsection' => true,
      'fields' => array(
	   array(
          'id'        => 'newpress__opt-body-text-color',
          'type'      => 'color',
          'title'     => esc_html__('Body Text Color', 'newpress'),
		   'default' => '#6e6e6e',
		  'output'  => array('body,.widget_categories a'),
		  'subtitle' => esc_html__('Theme Text Body Color Manage from the Redux Controller', 'newpress'),
        ),
		 array(
			'id'       => 'opt-color-blog',
			'type'     => 'background',
			'output'   => array('.site-content'),
			'title'    => esc_html__('Page Background Color', 'newpress'),
			'subtitle' => esc_html__('Pick a Page Background color for the theme', 'newpress'),
            'default'  => array(
            'background-color'    => '#ffffff',
          ),
		),
		 array(
			'id'       => 'opt-color-breadcums',
			'type'     => 'background',
			'output'  => array('.breadcrumb-area'),
			'title'    => esc_html__('Breadcums Background Color', 'newpress'),
			'subtitle' => esc_html__('Pick a Breadcums background color for the theme', 'newpress'),
			'default'               => array(
            'background-color'    => '#20282E',
			'background-image'    => get_template_directory_uri() . '/inc/assets/images/breadcrumb_bg.png',

          ),
		),
		array(
			'id'       => 'opt-color-footer',
			'type'     => 'background',
			'output'  => array('.footer-bg'),
			'title'    => esc_html__('Footer Background Color', 'newpress'),
			'subtitle' => esc_html__('Pick a Footer background color for the theme', 'newpress'),
			'default'               => array(
            'background-color'    => '#20282E',
            'background-image'    => get_template_directory_uri() . '/inc/assets/img/footer_bg.jpg',
          ),
		),
		array(
			'id'        => 'opt-color-bakground',
			'type'      => 'color',
			'title'     => esc_html__('Color', 'newpress'),
			'subtitle'  => esc_html__('Pick a background color.', 'newpress'),
			'default'   => '#c5015f',
			'output'    => array(
				'background-color' => 'choose-area .btn,.about-title p span,.wpcf7-form .btn,#scrollUp,.s-btn:hover,.pricing-box.active .pricing-btn .btn,.pricing-btn .btn:hover',
				'color'            => '.section-title span,.breadcrumb > .active,.elementor-widget-Elementor_title-bar2-widget .section-title span,.comment-text .avatar-name span',
				'border-color'     => '.pricing-box.active .pricing-btn .btn,.pricing-btn .btn:hover,.s-btn:hover,.s-features:hover .features-icon img,.f-cta-area.gray-bg'

			)
		),

		array(
			'id'        => 'opt-color-blue',
			'type'      => 'color',
			'title'     => esc_html__('Color Blue', 'newpress'),
			'subtitle'  => esc_html__('Pick a background color.', 'newpress'),
			'default'   => '#c5015f',
			'output'    => array(
				'background-color' => '.comment-form .submit:hover,.comment-text .avatar-name .comment-reply:hover a,.section-title h2::before,.bsingle__content .blog__btn .btn:hover,.search-form .search-submit,.widget-social a:hover',
				'color'            => '.b-meta ul li.corpo a,.main-menu ul li:hover > a,.s-single-services:hover .second-services-content h5,.s-single-services:hover .second-services-content a',
				'border-color'     => '.bsingle__content .blog__btn .btn,.comment-form .submit,.footer-bg'
			)
		),
		array(
			'id'        => 'opt-color-black',
			'type'      => 'color',
			'title'     => esc_html__('Color Black', 'newpress'),
			'subtitle'  => esc_html__('Pick a background color.', 'newpress'),
			'default'   => '#20282E',
			'output'    => array(
				'color'            => '.elementor-widget-Elementor_title-bar2-widget .section-title h2',
			)
		),
      )
    ) );






	 /////////////////////////////////////////////////footer ///////////////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Footer', 'newpress' ),
      'id'     => 'newpress__section-footer',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );
	

// Footer Text
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Footer Text', 'newpress' ),
      'id'     => 'newpress__subsection-footer-text',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'newpress__opt-footer-text',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'newpress'),
			'default'   => 2,
            'on'        => esc_html__( 'Yes', 'newpress' ),
            'off'       => esc_html__( 'No', 'newpress' ),
          ),
           /*array(
            'id'      => 'newpress__footer-logo-img',
              'type'      => 'media',
              'url'       => true,
              'title'     => esc_html__('Logo Icon', 'newpress'),
              'compiler'  => 'true',
              'desc'      => esc_html__('Upload your image or remove image', 'newpress'),
              'default'   => array(
              'url'     => get_template_directory_uri() . '/inc/assets/img/ft-icon01.png'),
            'required'  => array('newpress__opt-footer-text', '=', '1'),
          ),
          array(
            'id'      => 'newpress__footer-text',
            'type'    => 'editor',
            'title'   => esc_html__( 'Footer Text 1', 'newpress' ),
			'default'   => 1,
             'default' => '<span>Mon-Fri 9am-6pm</span>
                                    <h3> 8 800 567.890.11</h3>',
            'required'  => array('newpress__opt-footer-text', '=', '1'),
          ),*/
          
          
          
          
        
        
              
           
           )
    ) );


    // Footer Copyright
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Copyright', 'newpress' ),
      'id'     => 'newpress__subsection-footer-copyright',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'newpress__opt-copyright',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'newpress'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'newpress' ),
            'off'       => esc_html__( 'No', 'newpress' ),
          ),
		  
		
		  
          array(
            'id'      => 'newpress__copyright',
            'type'    => 'text',
            'title'   => esc_html__( 'Copyright Textarea', 'newpress' ),
			'default'   => 1,
            'default' => ' Copyright  &copy; 2021 newpress. All rights reserved.',
            'required'  => array('newpress__opt-copyright', '=', '1'),
          ),
          
           array(
            'id'      => 'newpress__footer-social',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Copyright Social Icons', 'newpress' ),
			'default'   => 1,
            'default' => 'Socialicons...',
            'required'  => array('newpress__opt-copyright', '=', '1'),
          ),
      )
    ) );

	
	

    // Footer Widgets
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Widgets', 'newpress' ),
      'id'     => 'newpress__subsection-footer-widgets',
	  'subsection' => true,
      'fields' => array(
        array(
          'id'        => 'newpress__opt-footer-widgets',
          'type'      => 'switch',
          'title'     => esc_html__('Switch', 'newpress'),
          'default'   => 2,
          'on'        => 'Show',
          'off'       => 'Hide',
        ),
        array(
          'id'        => 'newpress__opt-footer-widgets-layout',
          'type'      => 'image_select',
          'compiler'  => true,
          'title'     => esc_html__('Footer Widgets Layout', 'newpress'),
          'options'   => array(
            '1' => array(
              'alt' => esc_html__( '4 Columns (equal)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols2.png'),
            '2' => array(
              'alt' => esc_html__('4 Columns', 'newpress'),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols1.png'),
            '3' => array(
              'alt' => esc_html__( '3 Columns (left wider)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols3.png'),
            '4' => array(
              'alt' => esc_html__( '3 Columns (right wider)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols4.png'),
            '5' => array(
              'alt' => esc_html__( '3 Columns (equal)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols5.png'),
            '6' => array(
              'alt' => esc_html__( '2 Columns (right wider)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols6.png'),
            '7' => array(
              'alt' => esc_html__( '2 Columns (left wider)', 'newpress' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols7.png'),
          ),
          'default'   => '1',
          'required'  => array('newpress__opt-footer-widgets', '=', '1'),
        ),
      )
    ) );


    // Custom CSS
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Custom CSS', 'newpress' ),
      'id'     => 'newpress__section-custom-css',
      'icon'   => 'el el-css',
      'fields' => array(
        array(
          'id'        => 'newpress__opt-custom-css',
          'type'      => 'ace_editor',
          'title'     => esc_html__('CSS Code', 'newpress'),
          'subtitle'  => esc_html__('Paste your CSS code here.', 'newpress'),
          'mode'      => 'css',
          'theme'     => 'monokai',
          'desc'      => 'Any custom CSS can be added here, it will override the theme CSS.',
          'default'   => ""
        ),
      )
    ) );

    /*
     * <--- END SECTIONS--->
     */
