<?php
namespace Eventin\Blocks\BlockTypes;

use Eventin\Blocks\BlockTypes\AbstractBlock;
use Wpeventin;
 
/**
 * Event Venue Gutenberg block
 */
class EventRSVP extends AbstractBlock {

    /**
     * Namespace for the block
     */
    protected $namespace = 'eventin-pro';

    /**
     * Block name.
     *
     * @var string
     */
    protected $block_name = 'event-rsvp';

    /**
     * Include and render the block
     *
     * @param   array  $attributes  Block attributes. Default empty array
     * @param   string  $content     Block content. Default empty string
     * @param   WP_Block  $block       Block instance
     *
     * @return  string Rendered block type output
     */
    protected function render( $attributes, $content, $block ) {
        $container_class = ! empty( $attributes['containerClassName'] ) ? $attributes['containerClassName'] : '';
        $styles = ! empty( $attributes['styles'] ) ? $attributes['styles'] : [];

        if ( $this->is_editor() ) {
            $single_event_id = ! empty( $attributes['eventId'] ) ? intval( $attributes['eventId'] ) : 0;
        } else if ( 'etn-template' == get_post_type( get_the_ID() ) ) {
            $template = new \Eventin\Template\TemplateModel( get_the_ID() );
            $event_id = $template->get_preview_event_id();
        } else {
            $single_event_id = get_the_ID();
        } 
        ob_start();

        
        ?>
        <?php echo $this->render_frontend_css( $styles, $container_class ); ?>
        <?php
        require_once Wpeventin::templates_dir() . 'event/parts/rsvp.php';
        ?>

        <?php
        
        return ob_get_clean();
    }
}

